<?php
require 'config.php';
require_once 'FileStorage.php';

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die(json_encode(["success" => false, "error" => "Database connection failed: " . $conn->connect_error]));
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['id'])) {
    $id = intval($_POST['id']);
    
    // First, get the customer's mobile number
    $stmt = $conn->prepare("SELECT mobile FROM records WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $mobile = $row['mobile'];
        $stmt->close();
        
        // Delete the customer record from database
        $stmt = $conn->prepare("DELETE FROM records WHERE id = ?");
        $stmt->bind_param("i", $id);
        
        if ($stmt->execute()) {
            // Also delete associated verification submissions from encrypted files
            try {
                $fileStorage = new FileStorage();
                $fileStorage->deleteSubmissionsByMobile($mobile);
                error_log("Deleted submissions for mobile: " . $mobile);
            } catch (Exception $e) {
                error_log("Error deleting submissions: " . $e->getMessage());
                // Continue even if submission deletion fails
            }
            
            echo json_encode(["success" => true, "message" => "Record and associated submissions deleted successfully"]);
        } else {
            echo json_encode(["success" => false, "error" => "Failed to delete record: " . $conn->error]);
        }
        
        $stmt->close();
    } else {
        echo json_encode(["success" => false, "error" => "No record found with the given ID"]);
        $stmt->close();
    }
} else {
    echo json_encode(["success" => false, "error" => "Invalid request method or missing ID"]);
}

$conn->close();
?>
