<?php
require 'config.php';
require_once 'FileStorage.php';

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die(json_encode(["success" => false, "error" => "Database connection failed: " . $conn->connect_error]));
}

$sql = "DELETE FROM records";

if ($conn->query($sql) === TRUE) {
    // Also delete all verification submissions
    try {
        $fileStorage = new FileStorage();
        $result = $fileStorage->deleteAllSubmissions();
        
        if ($result['success']) {
            error_log("All customer records and submissions deleted");
            echo json_encode(["success" => true, "message" => "All customer records and verification submissions deleted successfully."]);
        } else {
            error_log("Records deleted but submissions deletion failed: " . $result['error']);
            echo json_encode(["success" => true, "message" => "Records deleted but some submissions may remain."]);
        }
    } catch (Exception $e) {
        error_log("Error deleting submissions: " . $e->getMessage());
        echo json_encode(["success" => true, "message" => "Records deleted successfully."]);
    }
} else {
    echo json_encode(["success" => false, "error" => "Error deleting records: " . $conn->error]);
}

$conn->close();
?>