document.addEventListener('DOMContentLoaded', function() {
    const loginForm = document.getElementById('admin-login-form');
    const adminIdInput = document.getElementById('admin-id');
    const adminPasswordInput = document.getElementById('admin-password');
    const togglePasswordBtn = document.querySelector('.toggle-password');
    const loginError = document.getElementById('login-error');
    const submitButton = document.querySelector('.btn-login');

    // Correct credentials
    const ADMIN_CREDENTIALS = {
        id: 'axisinsuranceadmin',
        password: 'axisinsurancepassword'
    };

    // Toggle password visibility
    if (togglePasswordBtn) {
        togglePasswordBtn.addEventListener('click', function() {
            const passwordInput = document.getElementById('admin-password');
            const icon = this.querySelector('i');
            
            if (passwordInput.type === 'password') {
                passwordInput.type = 'text';
                icon.classList.remove('fa-eye');
                icon.classList.add('fa-eye-slash');
            } else {
                passwordInput.type = 'password';
                icon.classList.remove('fa-eye-slash');
                icon.classList.add('fa-eye');
            }
        });
    }

    // Clear error message when user starts typing
    [adminIdInput, adminPasswordInput].forEach(input => {
        if (input) {
            input.addEventListener('input', function() {
                hideError();
            });
        }
    });

    // Handle form submission
    if (loginForm) {
        loginForm.addEventListener('submit', function(event) {
            event.preventDefault();
            
            const adminId = adminIdInput.value.trim();
            const adminPassword = adminPasswordInput.value.trim();

            // Validate inputs
            if (!adminId || !adminPassword) {
                showError('Please enter both Admin ID and Password.');
                return;
            }

            // Show loading state
            showLoading();

            // Simulate authentication delay
            setTimeout(() => {
                // Check credentials
                if (adminId === ADMIN_CREDENTIALS.id && adminPassword === ADMIN_CREDENTIALS.password) {
                    // Successful login
                    showSuccess('Login successful! Redirecting to admin panel...');
                    
                    // Store session information
                    sessionStorage.setItem('adminAuthenticated', 'true');
                    sessionStorage.setItem('adminLoginTime', new Date().toISOString());
                    
                    // Redirect to admin panel after a short delay
                    setTimeout(() => {
                        window.location.href = 'dashboard.html';
                    }, 1500);
                } else {
                    // Failed login
                    hideLoading();
                    showError('Invalid Admin ID or Password. Please try again.');
                    
                    // Clear password field for security
                    adminPasswordInput.value = '';
                    adminPasswordInput.focus();
                    
                    // Add shake animation to form
                    loginForm.classList.add('shake');
                    setTimeout(() => {
                        loginForm.classList.remove('shake');
                    }, 500);
                }
            }, 1500); // Simulate network delay
        });
    }

    // Show error message
    function showError(message) {
        loginError.textContent = message;
        loginError.classList.add('show');
        loginError.scrollIntoView({ behavior: 'smooth', block: 'nearest' });
    }

    // Hide error message
    function hideError() {
        loginError.classList.remove('show');
    }

    // Show success message
    function showSuccess(message) {
        hideError();
        
        // Create or update success element
        let successElement = document.querySelector('.login-success');
        if (!successElement) {
            successElement = document.createElement('div');
            successElement.className = 'login-success';
            loginError.parentNode.insertBefore(successElement, loginError.nextSibling);
        }
        
        successElement.textContent = message;
        successElement.classList.add('show');
        successElement.scrollIntoView({ behavior: 'smooth', block: 'nearest' });
    }

    // Show loading state
    function showLoading() {
        const originalText = submitButton.innerHTML;
        submitButton.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Signing In...';
        submitButton.classList.add('loading');
        submitButton.disabled = true;
        
        // Store original text for later restoration
        submitButton.dataset.originalText = originalText;
    }

    // Hide loading state
    function hideLoading() {
        const originalText = submitButton.dataset.originalText || '<i class="fas fa-sign-in-alt"></i> Sign In';
        submitButton.innerHTML = originalText;
        submitButton.classList.remove('loading');
        submitButton.disabled = false;
    }

    // Check if user is already logged in
    if (sessionStorage.getItem('adminAuthenticated') === 'true') {
        // Check if login is still valid (24 hours)
        const loginTime = new Date(sessionStorage.getItem('adminLoginTime'));
        const now = new Date();
        const hoursSinceLogin = (now - loginTime) / (1000 * 60 * 60);
        
        if (hoursSinceLogin < 24) {
            // Still logged in, redirect to admin panel
            showSuccess('You are already logged in. Redirecting...');
            setTimeout(() => {
                window.location.href = 'index.html';
            }, 1000);
        } else {
            // Session expired, clear storage
            sessionStorage.removeItem('adminAuthenticated');
            sessionStorage.removeItem('adminLoginTime');
        }
    }

    // Add enter key support for better UX
    [adminIdInput, adminPasswordInput].forEach(input => {
        if (input) {
            input.addEventListener('keypress', function(event) {
                if (event.key === 'Enter') {
                    loginForm.dispatchEvent(new Event('submit'));
                }
            });
        }
    });

    // Add focus management
    if (adminIdInput) {
        adminIdInput.focus();
    }

    // Add shake animation CSS if not already present
    if (!document.querySelector('#shake-style')) {
        const style = document.createElement('style');
        style.id = 'shake-style';
        style.textContent = `
            .shake {
                animation: shake 0.5s ease-in-out;
            }
            
            @keyframes shake {
                0%, 100% { transform: translateX(0); }
                25% { transform: translateX(-5px); }
                75% { transform: translateX(5px); }
            }
        `;
        document.head.appendChild(style);
    }

    // Handle browser back button
    window.addEventListener('popstate', function() {
        // Clear any error messages when navigating back
        hideError();
    });

    // Security: Clear sensitive data on page unload
    window.addEventListener('beforeunload', function() {
        if (adminPasswordInput) {
            adminPasswordInput.value = '';
        }
    });

    // Add auto-logout functionality
    let inactivityTimer;
    const INACTIVITY_TIMEOUT = 30 * 60 * 1000; // 30 minutes

    function resetInactivityTimer() {
        clearTimeout(inactivityTimer);
        inactivityTimer = setTimeout(() => {
            if (sessionStorage.getItem('adminAuthenticated') === 'true') {
                alert('Your session has expired due to inactivity. Please log in again.');
                sessionStorage.removeItem('adminAuthenticated');
                sessionStorage.removeItem('adminLoginTime');
                window.location.reload();
            }
        }, INACTIVITY_TIMEOUT);
    }

    // Track user activity
    ['mousedown', 'mousemove', 'keypress', 'scroll', 'touchstart'].forEach(event => {
        document.addEventListener(event, resetInactivityTimer, true);
    });

    // Initialize inactivity timer
    resetInactivityTimer();
});
